
-- USERS table stores Discord-linked profiles
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    discord_id VARCHAR(50) UNIQUE NOT NULL,
    username VARCHAR(100),
    avatar VARCHAR(255),
    role ENUM('Applicant', 'Member', 'Denied') DEFAULT 'Applicant',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- APPLICATIONS table stores form responses
CREATE TABLE applications (
    id INT AUTO_INCREMENT PRIMARY KEY,
    discord_id VARCHAR(50) NOT NULL,
    full_name VARCHAR(100),
    dob DATE,
    age INT,
    department VARCHAR(100),
    referral VARCHAR(255),
    agreement ENUM('Yes', 'No'),
    status ENUM('Pending', 'Approved', 'Denied') DEFAULT 'Pending',
    submitted_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
