
<?php
require 'config.php';
session_start();

if (!isset($_GET['code'])) {
    die("No code received.");
}

$code = $_GET['code'];

$data = [
    'client_id' => $client_id,
    'client_secret' => $client_secret,
    'grant_type' => 'authorization_code',
    'code' => $code,
    'redirect_uri' => $redirect_uri,
    'scope' => 'identify'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://discord.com/api/oauth2/token');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
$headers = ['Content-Type: application/x-www-form-urlencoded'];
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
$response = curl_exec($ch);
curl_close($ch);

$token = json_decode($response, true);
$access_token = $token['access_token'];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://discord.com/api/users/@me');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer ' . $access_token]);
$user_response = curl_exec($ch);
curl_close($ch);

$user = json_decode($user_response, true);
$discord_id = $user['id'];
$username = $user['username'];
$avatar = $user['avatar'];

$stmt = $conn->prepare("INSERT IGNORE INTO users (discord_id, username, avatar) VALUES (?, ?, ?)");
$stmt->bind_param("sss", $discord_id, $username, $avatar);
$stmt->execute();
$stmt->close();

$_SESSION['discord_id'] = $discord_id;
header("Location: profile.php");
?>
